/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeRenderBackgroundCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.fabric.CustomEnchantPower;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ProgressView;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.CallbackContainer;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.entry.BooleanConfigEntry;
import snownee.jade.impl.config.entry.EnumConfigEntry;
import snownee.jade.impl.config.entry.FloatConfigEntry;
import snownee.jade.impl.config.entry.IntConfigEntry;
import snownee.jade.impl.config.entry.StringConfigEntry;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.overlay.DatapackBlockManager;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.ClientPlatformProxy;

public class WailaClientRegistration
implements IWailaClientRegistration {
    public static final WailaClientRegistration INSTANCE = new WailaClientRegistration();
    public final HierarchyLookup<IBlockComponentProvider> blockIconProviders;
    public final HierarchyLookup<IBlockComponentProvider> blockComponentProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityIconProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityComponentProviders;
    public final Set<class_2248> hideBlocks = Sets.newHashSet();
    public final Set<class_1299<?>> hideEntities = Sets.newHashSet();
    public final Set<class_2248> pickBlocks = Sets.newHashSet();
    public final Set<class_1299<?>> pickEntities = Sets.newHashSet();
    public final CallbackContainer<JadeAfterRenderCallback> afterRenderCallback = new CallbackContainer();
    public final CallbackContainer<JadeBeforeRenderCallback> beforeRenderCallback = new CallbackContainer();
    public final CallbackContainer<JadeRayTraceCallback> rayTraceCallback = new CallbackContainer();
    public final CallbackContainer<JadeTooltipCollectedCallback> tooltipCollectedCallback = new CallbackContainer();
    public final CallbackContainer<JadeItemModNameCallback> itemModNameCallback = new CallbackContainer();
    public final CallbackContainer<JadeRenderBackgroundCallback> renderBackgroundCallback = new CallbackContainer();
    public final Map<class_2248, CustomEnchantPower> customEnchantPowers = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_1799, ItemView>> itemStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, FluidView>> fluidStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, EnergyView>> energyStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, ProgressView>> progressProviders = Maps.newHashMap();

    WailaClientRegistration() {
        this.blockIconProviders = new HierarchyLookup(class_2248.class);
        this.blockComponentProviders = new HierarchyLookup(class_2248.class);
        this.entityIconProviders = new HierarchyLookup(class_1297.class);
        this.entityComponentProviders = new HierarchyLookup(class_1297.class);
    }

    @Override
    public void registerBlockIcon(IBlockComponentProvider provider, Class<? extends class_2248> block) {
        this.blockIconProviders.register(block, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerBlockComponent(IBlockComponentProvider provider, Class<? extends class_2248> block) {
        this.blockComponentProviders.register(block, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityIcon(IEntityComponentProvider provider, Class<? extends class_1297> entity) {
        this.entityIconProviders.register(entity, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityComponent(IEntityComponentProvider provider, Class<? extends class_1297> entity) {
        this.entityComponentProviders.register(entity, provider);
        this.tryAddConfig(provider);
    }

    public List<IBlockComponentProvider> getBlockProviders(class_2248 block, Predicate<IBlockComponentProvider> filter) {
        return this.blockComponentProviders.get(block).stream().filter(filter).toList();
    }

    public List<IBlockComponentProvider> getBlockIconProviders(class_2248 block, Predicate<IBlockComponentProvider> filter) {
        return this.blockIconProviders.get(block).stream().filter(filter).toList();
    }

    public List<IEntityComponentProvider> getEntityProviders(class_1297 entity, Predicate<IEntityComponentProvider> filter) {
        return this.entityComponentProviders.get(entity).stream().filter(filter).toList();
    }

    public List<IEntityComponentProvider> getEntityIconProviders(class_1297 entity, Predicate<IEntityComponentProvider> filter) {
        return this.entityIconProviders.get(entity).stream().filter(filter).toList();
    }

    @Override
    public void hideTarget(class_2248 block) {
        this.hideBlocks.add(block);
    }

    @Override
    public void hideTarget(class_1299<?> entityType) {
        this.hideEntities.add(entityType);
    }

    @Override
    public void usePickedResult(class_2248 block) {
        this.pickBlocks.add(block);
    }

    @Override
    public void usePickedResult(class_1299<?> entityType) {
        this.pickEntities.add(entityType);
    }

    @Override
    public boolean shouldHide(class_2680 state) {
        return this.hideBlocks.contains(state.method_26204());
    }

    @Override
    public boolean shouldPick(class_2680 state) {
        return this.pickBlocks.contains(state.method_26204());
    }

    @Override
    public boolean shouldHide(class_1297 entity) {
        return this.hideEntities.contains(entity.method_5864());
    }

    @Override
    public boolean shouldPick(class_1297 entity) {
        return this.pickEntities.contains(entity.method_5864());
    }

    @Override
    public IElementHelper getElementHelper() {
        return ElementHelper.INSTANCE;
    }

    @Override
    public IDisplayHelper getDisplayHelper() {
        return DisplayHelper.INSTANCE;
    }

    @Override
    public IWailaConfig getConfig() {
        return Jade.CONFIG.get();
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        PluginConfig.INSTANCE.addConfig(new BooleanConfigEntry(key, defaultValue));
    }

    @Override
    public void addConfig(class_2960 key, Enum<?> defaultValue) {
        Objects.requireNonNull(defaultValue);
        PluginConfig.INSTANCE.addConfig(new EnumConfigEntry(key, defaultValue));
    }

    @Override
    public void addConfig(class_2960 key, String defaultValue, Predicate<String> validator) {
        Objects.requireNonNull(defaultValue);
        Objects.requireNonNull(validator);
        PluginConfig.INSTANCE.addConfig(new StringConfigEntry(key, defaultValue, validator));
    }

    @Override
    public void addConfig(class_2960 key, int defaultValue, int min, int max, boolean slider) {
        PluginConfig.INSTANCE.addConfig(new IntConfigEntry(key, defaultValue, min, max, slider));
    }

    @Override
    public void addConfig(class_2960 key, float defaultValue, float min, float max, boolean slider) {
        PluginConfig.INSTANCE.addConfig(new FloatConfigEntry(key, defaultValue, min, max, slider));
    }

    private void tryAddConfig(IToggleableProvider provider) {
        if (!provider.isRequired() && !PluginConfig.INSTANCE.containsKey(provider.getUid())) {
            this.addConfig(provider.getUid(), provider.enabledByDefault());
        }
    }

    public void loadComplete() {
        PriorityStore<class_2960, IJadeProvider> priorities = WailaCommonRegistration.INSTANCE.priorities;
        this.blockComponentProviders.loadComplete(priorities);
        this.blockIconProviders.loadComplete(priorities);
        this.entityComponentProviders.loadComplete(priorities);
        this.entityIconProviders.loadComplete(priorities);
        Stream.of(this.afterRenderCallback, this.beforeRenderCallback, this.rayTraceCallback, this.tooltipCollectedCallback, this.itemModNameCallback, this.renderBackgroundCallback).forEach(CallbackContainer::sort);
    }

    @Override
    public void addAfterRenderCallback(int priority, JadeAfterRenderCallback callback) {
        this.afterRenderCallback.add(priority, callback);
    }

    @Override
    public void addBeforeRenderCallback(int priority, JadeBeforeRenderCallback callback) {
        this.beforeRenderCallback.add(priority, callback);
    }

    @Override
    public void addRayTraceCallback(int priority, JadeRayTraceCallback callback) {
        this.rayTraceCallback.add(priority, callback);
    }

    @Override
    public void addTooltipCollectedCallback(int priority, JadeTooltipCollectedCallback callback) {
        this.tooltipCollectedCallback.add(priority, callback);
    }

    @Override
    public void addItemModNameCallback(int priority, JadeItemModNameCallback callback) {
        this.itemModNameCallback.add(priority, callback);
    }

    @Override
    public void addRenderBackgroundCallback(int priority, JadeRenderBackgroundCallback callback) {
        this.renderBackgroundCallback.add(priority, callback);
    }

    @Override
    public BlockAccessor.Builder blockAccessor() {
        class_310 mc = class_310.method_1551();
        return new BlockAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public EntityAccessor.Builder entityAccessor() {
        class_310 mc = class_310.method_1551();
        return new EntityAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public void registerCustomEnchantPower(class_2248 block, CustomEnchantPower customEnchantPower) {
        this.customEnchantPowers.put(block, customEnchantPower);
    }

    @Override
    public class_437 createPluginConfigScreen(@Nullable class_437 parent, String namespace) {
        return PluginsConfigScreen.createPluginConfigScreen(parent, namespace, false);
    }

    @Override
    public void registerItemStorageClient(IClientExtensionProvider<class_1799, ItemView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.itemStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerFluidStorageClient(IClientExtensionProvider<class_2487, FluidView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.fluidStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerEnergyStorageClient(IClientExtensionProvider<class_2487, EnergyView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.energyStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerProgressClient(IClientExtensionProvider<class_2487, ProgressView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.progressProviders.put(provider.getUid(), provider);
    }

    @Override
    public boolean isServerConnected() {
        return ObjectDataCenter.serverConnected;
    }

    @Override
    public boolean isShowDetailsPressed() {
        return ClientPlatformProxy.isShowDetailsPressed();
    }

    @Override
    public void setServerData(class_2487 tag) {
        ObjectDataCenter.setServerData(tag);
    }

    @Override
    public class_2487 getServerData() {
        return ObjectDataCenter.getServerData();
    }

    @Override
    public class_1799 getBlockCamouflage(class_1936 level, class_2338 pos) {
        return DatapackBlockManager.getFakeBlock(level, pos);
    }
}

